      SUBROUTINE INPSUM
C***********************************************************************
C                 INPSUM Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Print Out The Input Data Summary
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Arrays of Source Parameters
C                 Arrays of Receptor Locations
C                 Arrays of Model Results
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   MAIN
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE

C     Variable Initializations
      MODNAM = 'INPSUM'

C     Print Out The Model Options
      CALL PRTOPT

C     Print Out The Input Source Data
      CALL PRTSRC

      IF (.NOT. EVONLY) THEN
C        Print Out The Input Receptor Coordinates.
         CALL PRTREC

C        Check For Receptors Too Close To Sources (< 1m or < 3Lb)
         CALL CHKREC
      END IF

C     Print Out The Input Met Data Summary
      CALL PRTMET

      RETURN
      END

      SUBROUTINE PRTOPT
C***********************************************************************
C                 PRTOPT Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Print Out The Model Options and Keyword Summary
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To Remove Summary of Keywords Table
C                    Roger Brode, PES, Inc.,  - 11/08/94
C
C        MODIFIED:   To add pathway 'TG' to process input file of Gridded
C                    Terrain data.
C                    D. Strimaitis, SRC - 11/8/93
C
C        MODIFIED:   To add DDEP and WDEP parameters to CONC/DEPOS options
C                    to allow just the wet or just the dry deposition flux
C                    to be reported.  DEPOS now reports the sum of wet and
C                    dry fluxes.  Expand keywords to include input of wet
C                    scavenging coefficients (SO path).  Add override of
C                    Intermediate Terrain so that results are for only the
C                    simple terrain or the complex terrain model.
C                    D. Strimaitis, SRC - 11/8/93
C
C        MODIFIED:  To Include TOXXFILE Option - 9/29/92
C
C        INPUTS:  Model Options and Keyword Summarys
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   INPSUM
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, ILMAX
      REAL    :: STORE

C     Variable Initializations
      MODNAM = 'PRTOPT'

C     Summarize The Model Options
      CALL HEADER
      WRITE(IOUNIT,9041)
      IF (NOSMPL) THEN
         WRITE(IOUNIT,*) '**Complex Terrain Model is Selected'
      ELSE IF (NOCMPL) THEN
         WRITE(IOUNIT,*) '**Simple Terrain Model is Selected'
      ELSE
         WRITE(IOUNIT,*) '**Intermediate Terrain Processing is Selected'
      ENDIF

      WRITE(IOUNIT,9099)
      IF (CONC) THEN
         WRITE(IOUNIT,*) '**Model Is Setup For Calculation of ',
     &        'Average CONCentration Values.'
      END IF
      IF (DEPOS) THEN
         WRITE(IOUNIT,*) '**Model Is Setup For Calculation of ',
     &        'Total DEPOSition Values.'
      END IF
      IF (DDEP) THEN
         WRITE(IOUNIT,*) '**Model Is Setup For Calculation of ',
     &        'Dry DEPosition Values.'
      END IF
      IF (WDEP) THEN
         WRITE(IOUNIT,*) '**Model Is Setup For Calculation of ',
     &        'Wet DEPosition Values.'
      END IF

      WRITE(IOUNIT,9099)
      WRITE(IOUNIT,*) '  --  SCAVENGING/DEPOSITION LOGIC --'
      IF (DDPLETE) THEN
         WRITE(IOUNIT,*) '**Model Uses DRY DEPLETION.  DDPLETE = ',
     &                    DDPLETE
      ELSE
         WRITE(IOUNIT,*) '**Model Uses NO DRY DEPLETION.  DDPLETE = ',
     &                    DDPLETE
      END IF
      IF (WDPLETE) THEN
         WRITE(IOUNIT,*) '**Model Uses WET DEPLETION.  WDPLETE = ',
     &                    WDPLETE
      ELSE
         WRITE(IOUNIT,*) '**Model Uses NO WET DEPLETION.  WDPLETE = ',
     &                    WDPLETE
      END IF
      IF (LWGAS .OR. LWPART) THEN
         WRITE(IOUNIT,*) '**SCAVENGING Data Provided.  LWGAS,LWPART = ',
     &                    LWGAS,LWPART
      ELSE
         WRITE(IOUNIT,*) '**NO WET SCAVENGING Data Provided. '
      END IF
      IF (LDGAS .AND. LUSERVD) THEN
         WRITE(IOUNIT,*)'**USER-SPECIFIED DRY DEPOSITION VELOCITY for ',
     &                  'Gases Provided.  LDGAS = ',LDGAS
      ELSE IF (LDGAS) THEN
         WRITE(IOUNIT,*)'**GAS DRY DEPOSITION Data Provided.  LDGAS = ',
     &                    LDGAS
         IF (UNSTRESSED) THEN
            WRITE(IOUNIT,*) '**State of Vegetation is Active and ',
     &                      'UNSTRESSED.'
         ELSE IF (STRESSED) THEN
            WRITE(IOUNIT,*) '**State of Vegetation is Active and ',
     &                      'STRESSED.'
         ELSE IF (INACTIVE) THEN
            WRITE(IOUNIT,*) '**State of Vegetation is INACTIVE.'
         END IF
      ELSE
         WRITE(IOUNIT,*) '**NO GAS DRY DEPOSITION Data Provided. '
      END IF
      IF (LTGRID) THEN
         WRITE(IOUNIT,*) '**Model Uses GRIDDED TERRAIN Data for ',
     &                   'Depletion Calculations'
      ELSE
         WRITE(IOUNIT,*) '**Model Does NOT Use GRIDDED TERRAIN Data ',
     &                   'for Depletion Calculations'
      END IF

      WRITE(IOUNIT,9099)
      IF (RURAL) THEN
         WRITE(IOUNIT,*) '**Model Uses RURAL Dispersion.'
      ELSE IF (URBAN) THEN
         WRITE(IOUNIT,*) '**Model Uses URBAN Dispersion.'
      END IF

      WRITE(IOUNIT,9099)
      IF (DFAULT) THEN
         WRITE(IOUNIT,*) '**Model Uses Regulatory DEFAULT Options:'
         WRITE(IOUNIT,*) '           1. Final Plume Rise.'
         WRITE(IOUNIT,*) '           2. Stack-tip Downwash.'
         WRITE(IOUNIT,*) '           3. Buoyancy-induced ',
     &           'Dispersion.'
         WRITE(IOUNIT,*) '           4. Use Calms Processing ',
     &           'Routine.'
         WRITE(IOUNIT,*) '           5. Not Use Missing Data ',
     &           'Processing Routine.'
         WRITE(IOUNIT,*) '           6. Default Wind Profile Exponents.'
         WRITE(IOUNIT,*) '           7. Default Vertical Potential',
     &           ' Temperature Gradients.'
         WRITE(IOUNIT,*) '           8. "Upper Bound" Values ',
     &           'for Supersquat Buildings.'
         IF (URBAN .AND. POLLUT .EQ. 'SO2') THEN
            WRITE(IOUNIT,*) '           9. Half-life of 4 hrs for',
     &              ' URBAN SO2.'
         ELSE IF (URBAN .AND. POLLUT .NE. 'SO2') THEN
            WRITE(IOUNIT,*) '           9. No Exponential Decay for',
     &              ' URBAN/Non-SO2'
         ELSE
            WRITE(IOUNIT,*) '           9. No Exponential Decay for',
     &              ' RURAL Mode'
         END IF
      ELSE
         WRITE(IOUNIT,*) '**Model Uses User-Specified Options:'
         IF (GRDRIS) THEN
            WRITE(IOUNIT,*) '           1. Gradual Plume Rise.'
         ELSE
            WRITE(IOUNIT,*) '           1. Final Plume Rise.'
         END IF
         IF (NOSTD) THEN
            WRITE(IOUNIT,*) '           2. Not Use Stack-tip ',
     &           'Downwash.'
         ELSE
            WRITE(IOUNIT,*) '           2. Stack-tip Downwash.'
         END IF
         IF (NOBID) THEN
            WRITE(IOUNIT,*) '           3. Not Use Buoyancy-induced ',
     &           'Dispersion.'
         ELSE
            WRITE(IOUNIT,*) '           3. Buoyancy-induced ',
     &           'Dispersion.'
         END IF
         IF (NOCALM) THEN
            WRITE(IOUNIT,*) '           4. Not Use Calms Processing ',
     &           'Routine.'
         ELSE
            WRITE(IOUNIT,*) '           4. Calms Processing ',
     &           'Routine.'
         END IF
         IF (MSGPRO) THEN
            WRITE(IOUNIT,*) '           5. Missing Data Processing ',
     &           'Routine.'
         ELSE
            WRITE(IOUNIT,*) '           5. Not Use Missing Data ',
     &           'Processing Routine.'
         END IF
         IF (USERP) THEN
            WRITE(IOUNIT,*) '           6. User-Specified Wind Profile',
     &           ' Exponents.'
         ELSE
            WRITE(IOUNIT,*) '           6. Default Wind Profile',
     &           ' Exponents.'
         END IF
         IF (USERDT) THEN
            WRITE(IOUNIT,*) '           7. User-Specified Vertical ',
     &           'Potential Temperature Gradients.'
         ELSE
            WRITE(IOUNIT,*) '           7. Default Vertical Potential',
     &           ' Temperature Gradients.'
         END IF
      END IF
      
C*----   ISCSTM Modification: allow for NOCHKD option - jah 11/2/94                           
      IF (NOCHKD) THEN
         WRITE(IOUNIT,*) '           NOCHKD - Suppresses checking',
     &                   ' of date sequence in meteorology files.'
      END IF
      IF (TOXICS) THEN
         WRITE(IOUNIT,*) '           TOXICS - Allows use of TOXICS',
     &                   ' option enhancements.'
      END IF
      IF (SCIM) THEN
         WRITE(IOUNIT,*) '           SCIM   - Uses Sampled',
     &                   ' Chronological Input Model option.'
      END IF
      IF (HEGTZI) THEN
         WRITE(IOUNIT,*) '           HE>ZI  - Adjusts Vertical',
     &                   ' Term for cases when HE > ZI,'
         WRITE(IOUNIT,*) '                    which may occur for',
     &                   ' receptors below source base elevation.'
      END IF
C*#
      WRITE(IOUNIT,9099)
      IF (FLAT) THEN
         WRITE(IOUNIT,*) '**Model Assumes Receptors on FLAT Terrain.'
      ELSE IF (ELEV) THEN
         WRITE(IOUNIT,*) '**Model Accepts Receptors on ELEV Terrain.'
      END IF

      WRITE(IOUNIT,9099)
      IF (FLGPOL) THEN
         WRITE(IOUNIT,*) '**Model Accepts FLAGPOLE Receptor Heights.'
      ELSE
         WRITE(IOUNIT,*) '**Model Assumes No FLAGPOLE Receptor Heights.'
      END IF

C     Model Sources And Receptors Summary
      WRITE(IOUNIT,9099)
      IF (PERIOD) THEN
         IF (NUMAVE .GT. 0) THEN
            WRITE(IOUNIT,9042) NUMAVE, (CHRAVE(I),I=1,NUMAVE)
            WRITE(IOUNIT,9043)
         ELSE
            WRITE(IOUNIT,9045)
         END IF
      ELSE IF (ANNUAL) THEN
         IF (NUMAVE .GT. 0) THEN
            WRITE(IOUNIT,9042) NUMAVE, (CHRAVE(I),I=1,NUMAVE)
            WRITE(IOUNIT,9143)
         ELSE
            WRITE(IOUNIT,9145)
         END IF
      ELSE
         WRITE(IOUNIT,9042) NUMAVE, (CHRAVE(I),I=1,NUMAVE)
      END IF

C     Write Out Numbers of Sources, Groups, and Receptors for This Run
      WRITE(IOUNIT,9099)
      IF (EVONLY) THEN
         WRITE(IOUNIT,9046) NUMSRC, NUMGRP, NUMEVE
      ELSE IF (.NOT. EVONLY) THEN
         WRITE(IOUNIT,9044) NUMSRC, NUMGRP, NUMREC
      END IF

C     Write Out Pollutant Type
      WRITE(IOUNIT,9099)
      WRITE(IOUNIT,9048) POLLUT

C     Model Run OR Not Options
      WRITE(IOUNIT,9099)
      IF (RUN) THEN
         WRITE(IOUNIT,*) '**Model Set To Continue RUNning After the ',
     &         'Setup Testing.'
      ELSE
         WRITE(IOUNIT,*) '**Model Will NOT Run After the ',
     &         'Setup Testing.'
      END IF

C     Model Output Options Setting Summary
      WRITE(IOUNIT,9099)
      WRITE(IOUNIT,9070)
      IF (PERIOD) THEN
C        PERIOD Averages by Receptor Are Output
         WRITE(IOUNIT,9071)
      ELSE IF (ANNUAL) THEN
C        ANNUAL Averages by Receptor Are Output
         WRITE(IOUNIT,9171)
      END IF
      IF (IOSTAT(2) .GT. 0) THEN
C        RECTABLE Keyword Used
         WRITE(IOUNIT,9072)
      END IF
      IF (IOSTAT(3) .GT. 0) THEN
C        MAXTABLE Keyword Used
         WRITE(IOUNIT,9073)
      END IF
      IF (IOSTAT(4) .GT. 0) THEN
C        DAYTABLE Keyword Used
         WRITE(IOUNIT,9074)
      END IF
      IF (IOSTAT(5) .GT. 0) THEN
C        MAXIFILE Keyword Used
         WRITE(IOUNIT,9075)
      END IF
      IF (IOSTAT(6) .GT. 0) THEN
C        POSTFILE Keyword Used
         WRITE(IOUNIT,9076)
      END IF
      IF (IOSTAT(7) .GT. 0) THEN
C        PLOTFILE Keyword Used
         WRITE(IOUNIT,9077)
      END IF
      IF (IOSTAT(8) .GT. 0) THEN
C        TOXXFILE Keyword Used
         WRITE(IOUNIT,9078)
      END IF

C     Write Explanatory Note About Calm and Missing Flags
      IF (CLMPRO .OR. MSGPRO) THEN
         WRITE(IOUNIT,9099)
         WRITE(IOUNIT,9079) CHIDEP(3,1)
      END IF

C     Model Misc. Information
      WRITE(IOUNIT,9099)
      WRITE(IOUNIT,9050) ZREF, DECOEF, ROTANG
      WRITE(IOUNIT,9055) EMILBL(1), EMIFAC(1), OUTLBL(1)
      IF (LUSERVD) THEN
         WRITE(IOUNIT,9056)  USERVD
      END IF

      IF (.NOT. EVONLY) THEN
C        Calculate Allocated Storage Requirements (est.)
         STORE = NSRC*(37+NQF+3*NSEC+8*NPDMAX+2*NVMAX+NWET+NGRP) +
     &           NPDMAX*(21+NWET) +
     &           NREC*(8+NHIVAL*NGRP*NAVE*NTYP*2.25+NGRP*NAVE*NTYP+
     &                 NGRP*NTYP) +
     &           NNET*(9+IXM+IYM) +
     &           NHIVAL*(NGRP*NAVE*NTYP*3.25+NGRP*NTYP*2+NAVE) +
     &           NMXVAL*(NGRP*NAVE*NTYP*3.25) +
     &           NAVE*(21+2*NPAIR+12*NHIVAL*NGRP+39*NGRP) +
     &           NGRP*55 + NTYP*23 + NVMAX*10
         STORE = STORE*4./1.0E6 + 1.2
         WRITE(IOUNIT,9099)
         WRITE(IOUNIT,9057) STORE
      END IF

C     Model I/O Setting Summary
      WRITE(IOUNIT,9099)
      ILMAX = MIN( 80, ILEN_FLD )
      IF (INPFIL .NE. ' ' .OR. OUTFIL .NE. ' ') THEN
         WRITE(IOUNIT,9080) INPFIL(1:ILMAX), OUTFIL(1:ILMAX)
      END IF
      IF (ERRLST) WRITE(IOUNIT,9081) MSGFIL(1:ILMAX)
      IF (EVENTS) WRITE(IOUNIT,9082) EVFILE(1:ILMAX)
      IF (RSTSAV) WRITE(IOUNIT,9083) SAVFIL(1:ILMAX)
      IF (RSTINP) WRITE(IOUNIT,9084) INIFIL(1:ILMAX)

      IF (MULTYR) THEN
         WRITE(IOUNIT,*) '**This Run is Part of a Multi-year Run.'
         WRITE(IOUNIT,*) '  NOTE:  PERIOD Results Are for Current ',
     &                   'Period Only.'
         WRITE(IOUNIT,*) '         Short Term Results Are Cumulative',
     &                   ' Across All Years Processed.'
      END IF

 9041 FORMAT(44X,'***     MODEL SETUP OPTIONS SUMMARY       ***'/
     &       63(' -')/)
 9042 FORMAT(1X,'**Model Calculates ',I2,' Short Term Average(s)',
     &       ' of:  ',9(A5,2X,:))
 9043 FORMAT(1X,'    and Calculates PERIOD Averages')
 9045 FORMAT(1X,'**Model Calculates PERIOD Averages Only')
 9143 FORMAT(1X,'    and Calculates ANNUAL Averages')
 9145 FORMAT(1X,'**Model Calculates ANNUAL Averages Only')
 9044 FORMAT(1X,'**This Run Includes: ',I5,' Source(s);  ',I5,
     &       ' Source Group(s); and  ',I6,' Receptor(s)')
 9046 FORMAT(1X,'**This Run Includes: ',I5,' Source(s);  ',I5,
     &       ' Source Group(s); and  ',I6,' Event(s)')
 9048 FORMAT(1X,'**The Model Assumes A Pollutant Type of:  ',A8)
 9050 FORMAT(1X,'**Misc. Inputs:  Anem. Hgt. (m) = ',F8.2,
     &       ' ;    Decay Coef. = ',G12.4,' ;    Rot. Angle = ',F7.1)
 9055 FORMAT(18X,'Emission Units = ',A40,' ;  Emission Rate Unit ',
     &       'Factor = ',G13.5,
     &      /18X,'Output Units   = ',A40)
 9056 FORMAT(18X,'User-Specified Dry Deposition Velocity for Gases ',
     &       '(m/s) = ',G13.5)
 9057 FORMAT(1X,'**Approximate Storage Requirements of Model = ',F7.1,
     &       ' MB of RAM.')
 9070 FORMAT(1X,'**Output Options Selected:')
 9071 FORMAT(10X,'Model Outputs Tables of PERIOD Averages by Receptor')
 9171 FORMAT(10X,'Model Outputs Tables of ANNUAL Averages by Receptor')
 9072 FORMAT(10X,'Model Outputs Tables of Highest Short Term Values by',
     &       ' Receptor (RECTABLE Keyword)')
 9073 FORMAT(10X,'Model Outputs Tables of Overall Maximum Short Term',
     &       ' Values (MAXTABLE Keyword)')
 9074 FORMAT(10X,'Model Outputs Tables of Concurrent Short Term Values',
     &       ' by Receptor for Each Day Processed (DAYTABLE Keyword)')
 9075 FORMAT(10X,'Model Outputs External File(s) of Threshold',
     &       ' Violations (MAXIFILE Keyword)')
 9076 FORMAT(10X,'Model Outputs External File(s) of Concurrent Values',
     &       ' for Postprocessing (POSTFILE Keyword)')
 9077 FORMAT(10X,'Model Outputs External File(s) of High Values for',
     &       ' Plotting (PLOTFILE Keyword)')
 9078 FORMAT(10X,'Model Outputs External File(s) of Values for Input',
     &       ' to TOXX Model (TOXXFILE Keyword)')
 9079 FORMAT(1X,'**NOTE:  The Following Flags May Appear Following ',
     &       A4,' Values:  c for Calm Hours',
     &               /65X,'m for Missing Hours',
     &               /65X,'b for Both Calm and Missing Hours')
 9080 FORMAT(1X,'**Input Runstream File:          ',A80,
     &      /1X,'**Output Print File:             ',A80)
 9081 FORMAT(1X,'**Detailed Error/Message File:   ',A80)
 9082 FORMAT(1X,'**File Created for Event Model:  ',A80)
 9083 FORMAT(1X,'**File for Saving Result Arrays: ',A80)
 9084 FORMAT(1X,'**File for Initializing Arrays:  ',A80)

 9099 FORMAT(1X,' ')

      RETURN
      END

      SUBROUTINE PRTSRC
C***********************************************************************
C                 PRTSRC Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Print Out The Input Source Data Summary
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        MODIFIED BY D. Strimaitis, SRC (for Wet & Dry DEPOSITION)
C
C        DATE:    November 8, 1993
C
C        MODIFIED by YICHENG ZHUANG, SRC to combine version 93188 with
C                 version 93046 - 9/28/93
C
C        MODIFIED BY D. Strimaitis, SRC (for DEPOSITION) - 2/25/93
C
C*       MODIFIED BY PES (for OPENPIT Source) - 7/22/94
C
C*       MODIFIED BY PES to properly handle page breaks in summary
C*                of sources within a source group - 11/19/98
C
C        INPUTS:  Model Options and Keyword Summarys
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   INPSUM
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, J, K, NL, I1, I2, I3, IFR, IDW, ITO, INDC, INGRP
      CHARACTER BLDING*3, IQUN*12
      CHARACTER ATHRUF(6)*1, SEASON(4)*6, DAYOFWEEK(3)*8

C     Variable Initializations
      DATA ATHRUF / 'A','B','C','D','E','F' /
      DATA SEASON /'WINTER','SPRING','SUMMER',' FALL '/
      DATA DAYOFWEEK /'WEEKDAY ','SATURDAY','SUNDAY  '/
      MODNAM = 'PRTSRC'

      IF (ISSTAT(8) .EQ. 0) THEN
C        Write Default Emission Rate Units
         IQUN = ' (GRAMS/SEC)'
      ELSE
         IQUN = '(USER UNITS)'
      END IF

C     Write Out The Point Source Data, If Any
      INDC = 0
      DO I = 1, NUMSRC
         IF (SRCTYP(I) .EQ. 'POINT') THEN
            INDC = INDC + 1
            BLDING = 'NO'
            DO J = 1, NSEC
               IF (ADSBH(J,I).NE.0.0 .AND. ADSBW(J,I).NE.0.0) THEN
                  BLDING = 'YES'
               END IF
            END DO
            IF (MOD(INDC-1,40) .EQ. 0) THEN
               CALL HEADER
               WRITE(IOUNIT,9046) IQUN
            END IF
            WRITE(IOUNIT,9047) SRCID(I),INPD(I),AQS(I),
     &              AXS(I),AYS(I),AZS(I),AHS(I),ATS(I),AVS(I),ADS(I),
     &              BLDING,QFLAG(I)
         END IF
      END DO

C     Write Out The Volume Source Data, If Any
      INDC = 0
      DO I = 1, NUMSRC
         IF (SRCTYP(I) .EQ. 'VOLUME') THEN
            INDC = INDC + 1
            IF (MOD(INDC-1,40) .EQ. 0) THEN
               CALL HEADER
               WRITE(IOUNIT,9074) IQUN
            END IF
            WRITE(IOUNIT,9075) SRCID(I),INPD(I),AQS(I),
     &              AXS(I),AYS(I),AZS(I),AHS(I),ASYINI(I),ASZINI(I),
     &              QFLAG(I)
         END IF
      END DO

C     Write Out The Area Source Data, If Any
      INDC = 0
      DO I = 1, NUMSRC
         IF (SRCTYP(I) .EQ. 'AREA') THEN
            INDC = INDC + 1
            IF (MOD(INDC-1,40) .EQ. 0) THEN
               CALL HEADER
               WRITE(IOUNIT,9076) IQUN
            END IF
            WRITE(IOUNIT,9077) SRCID(I),INPD(I),AQS(I),
     &              AXS(I),AYS(I),AZS(I),AHS(I),AXINIT(I),AYINIT(I),
     &              AANGLE(I), ASZINI(I), QFLAG(I)
C*----     
         END IF
         
      END DO

C     Write Out The AREACIRC Source Data, If Any
      INDC = 0
      DO I = 1, NUMSRC
         IF (SRCTYP(I) .EQ. 'AREACIRC') THEN
            INDC = INDC + 1
            IF (MOD(INDC-1,40) .EQ. 0) THEN
               CALL HEADER
               WRITE(IOUNIT,9078) IQUN
            END IF
            WRITE(IOUNIT,9079) SRCID(I), INPD(I), AQS(I),
     &              AXS(I), AYS(I), AZS(I), AHS(I), RADIUS(I),
     &              NVERTS(I), ASZINI(I), QFLAG(I)
         END IF
      END DO

C     Write Out The AREAPOLY Source Data, If Any
      INDC = 0
      DO I = 1, NUMSRC
         IF (SRCTYP(I) .EQ. 'AREAPOLY') THEN
            INDC = INDC + 1
            IF (MOD(INDC-1,40) .EQ. 0) THEN
               CALL HEADER
               WRITE(IOUNIT,9080) IQUN
            END IF
            WRITE(IOUNIT,9081) SRCID(I), INPD(I), AQS(I),
     &              AXS(I), AYS(I), AZS(I), AHS(I), NVERTS(I),
     &              ASZINI(I), QFLAG(I)
         END IF
      END DO

C*    Write Out The OpenPit Source Data, If Any
      INDC = 0
      DO I = 1, NUMSRC
         IF (SRCTYP(I) .EQ. 'OPENPIT') THEN
            INDC = INDC + 1
            IF (MOD(INDC-1,40) .EQ. 0) THEN
               CALL HEADER
               WRITE(IOUNIT,9082) IQUN
            END IF
            WRITE(IOUNIT,9083) SRCID(I),INPD(I),AQS(I),
     &              AXS(I),AYS(I),AZS(I),AHS(I),AXINIT(I),AYINIT(I),
     &              AANGLE(I), AVOLUM(I), QFLAG(I)
         END IF
      END DO

C     Print The Source Group IDs with Source IDs
      INDC = 0
      DO J = 1, NUMGRP
         INGRP = 0
         DO K = 1, NUMSRC
            IF (IGROUP(K,J) .EQ. 1) THEN
               INGRP = INGRP + 1
               WORKID(INGRP) = SRCID(K)
            END IF
         END DO
C        Determine Number of Lines @ 12/Line
         NL = 1 + INT((INGRP-1)/12)
         DO K = 1, NL
            INDC = INDC + 1
            IF (MOD(INDC-1,20) .EQ. 0) THEN
               CALL HEADER
               WRITE(IOUNIT,9058)
            END IF
            IF (K .EQ. 1 .AND. K .EQ. NL) THEN
               WRITE(IOUNIT,9068) GRPID(J), (WORKID(I),I=1,INGRP)
            ELSE IF (K .EQ. 1 .AND. K .NE. NL) THEN
               WRITE(IOUNIT,9068) GRPID(J), (WORKID(I),I=1,12*K)
            ELSE IF (K .EQ. NL) THEN
               WRITE(IOUNIT,9067) (WORKID(I),I=1+12*(K-1),INGRP)
            ELSE
               WRITE(IOUNIT,9067) (WORKID(I),I=1+12*(K-1),12*K)
            END IF
         END DO
      END DO

C     Print Out Wet or Dry Deposition Information.
      INDC = 0
      DO I = 1, NUMSRC
         NPD = INPD(I)
         IF (NPD .NE. 0) THEN
            INDC = INDC + 1
            IF (MOD(INDC-1,3) .EQ. 0) THEN
               CALL HEADER
               WRITE(IOUNIT,9049)
            END IF
            WRITE(IOUNIT,9050) SRCID(I), SRCTYP(I)
            WRITE(IOUNIT,9051) (APHI(J,I),J=1,NPD)
            WRITE(IOUNIT,9052) (APDIAM(J,I),J=1,NPD)
            WRITE(IOUNIT,9053) (APDENS(J,I),J=1,NPD)
            IF (LWPART) THEN
               WRITE(IOUNIT,9054) (APSLIQ(J,I),J=1,NPD)
               WRITE(IOUNIT,9055) (APSICE(J,I),J=1,NPD)
            END IF
         ELSE IF (LWGAS .OR. (LDGAS .AND. .NOT.LUSERVD)) THEN
            INDC = INDC + 1
            IF (MOD(INDC-1,3) .EQ. 0) THEN
               CALL HEADER
               WRITE(IOUNIT,9049)
            END IF
            WRITE(IOUNIT,9050) SRCID(I), SRCTYP(I)
            IF (LDGAS) THEN
               WRITE(IOUNIT,9090) PDIFF(I)
               WRITE(IOUNIT,9091) ALPHAS(I)
               WRITE(IOUNIT,9092) REACT(I)
               WRITE(IOUNIT,9093) RM(I)
               WRITE(IOUNIT,9094) HENRY(I)
            END IF
            IF (LWGAS) THEN
               WRITE(IOUNIT,9085) AGSCAV(1,I)
               WRITE(IOUNIT,9086) AGSCAV(2,I)
            END IF

         END IF
      END DO

C     Write Out Direction Specific Bldg. Dimensions, If Present
      INDC = 0
      DO I = 1, NUMSRC
         BLDING = 'NO'
         DO J = 1, NSEC
            IF (ADSBH(J,I).NE.0.0 .AND. ADSBW(J,I).NE.0.0) THEN
               BLDING = 'YES'
            END IF
         END DO
         IF (BLDING .EQ. 'YES') THEN
            INDC = INDC + 1
C           Print Out Direction Specific Bldg. Dimensions
            IF (MOD(INDC-1,4) .EQ. 0) THEN
               CALL HEADER
               WRITE(IOUNIT,9064)
            END IF
            WRITE(IOUNIT,9062) SRCID(I),
     &           (J,ABS(ADSBH(J,I)),ADSBW(J,I),IDSWAK(J,I), J=1,NSEC)
         END IF
      END DO

C     Print Source Emission Rate Scalars.
      INDC = 0
      DO I = 1, NUMSRC
         IF (QFLAG(I) .EQ. 'SEASON') THEN
            INDC = INDC + 1
            IF (MOD(INDC-1,6) .EQ. 0) THEN
               CALL HEADER
               WRITE(IOUNIT,9002)
               WRITE(IOUNIT,9004) (SEASON(I1),I1=1,4)
            END IF
            WRITE(IOUNIT,9005) SRCID(I),SRCTYP(I)
            WRITE(IOUNIT,9006) (QFACT(I1,I),I1=1,4)
         END IF
      END DO

      INDC = 0
      DO I = 1, NUMSRC
         IF (QFLAG(I) .EQ. 'MONTH') THEN
            INDC = INDC + 1
            IF (MOD(INDC-1,6) .EQ. 0) THEN
               CALL HEADER
               WRITE(IOUNIT,9007)
               WRITE(IOUNIT,9008)
               WRITE(IOUNIT,9013)
            END IF
            WRITE(IOUNIT,9009) SRCID(I),SRCTYP(I)
            WRITE(IOUNIT,9010) (QFACT(I1,I),I1=1,12)
         END IF
      END DO

      INDC = 0
      DO I = 1, NUMSRC
         IF (QFLAG(I) .EQ. 'HROFDY') THEN
            INDC = INDC + 1
            IF (MOD(INDC-1,5) .EQ. 0) THEN
               CALL HEADER
               WRITE(IOUNIT,9011)
               WRITE(IOUNIT,9012)
               WRITE(IOUNIT,9013)
            END IF
            WRITE(IOUNIT,9009) SRCID(I),SRCTYP(I)
            WRITE(IOUNIT,9014) (I1,QFACT(I1,I),I1=1,24)
         END IF
      END DO

      INDC = 0
      DO I = 1, NUMSRC
         IF (QFLAG(I) .EQ. 'STAR') THEN
            INDC = INDC + 1
            IF (MOD(INDC-1,3) .EQ. 0) THEN
               CALL HEADER
               WRITE(IOUNIT,9015)
               WRITE(IOUNIT,9013)
            END IF
            WRITE(IOUNIT,9009) SRCID(I),SRCTYP(I)
            WRITE(IOUNIT,9025) (J, J=1,6)
            DO I1 = 1,6
               IFR = (I1-1)*6 + 1
               ITO = IFR + 5
               WRITE(IOUNIT,9024) ATHRUF(I1),
     &               (QFACT(I2,I),I2=IFR,ITO)
            END DO
         END IF
      END DO

      INDC = 0
      DO I = 1, NUMSRC
         IF (QFLAG(I) .EQ. 'SEASHR') THEN
            INDC = INDC + 1
C            IF (MOD(INDC-1,1) .EQ. 0) THEN
               CALL HEADER
               WRITE(IOUNIT,9018)
               WRITE(IOUNIT,9012)
               WRITE(IOUNIT,9013)
C            END IF
            WRITE(IOUNIT,9009) SRCID(I),SRCTYP(I)
            DO I1 = 1, 4
               IFR = (I1-1)*24
               WRITE(IOUNIT,9019) SEASON(I1)
               WRITE(IOUNIT,9014) (I2,QFACT(I2+IFR,I),I2=1,24)
            END DO
         END IF
      END DO

      INDC = 0
      DO I = 1, NUMSRC
         IF (QFLAG(I) .EQ. 'SHRDOW') THEN
            INDC = INDC + 1
C            IF (MOD(INDC-1,1) .EQ. 0) THEN
               CALL HEADER
               WRITE(IOUNIT,99018)
               WRITE(IOUNIT,99009) SRCID(I), SRCTYP(I)
               WRITE(IOUNIT,99012)
               WRITE(IOUNIT,99013)
C            END IF
            DO I1 = 1, 3
               IDW = (I1-1)*96
               DO I2 = 1, 4
                  IFR = (I2-1)*24
                  WRITE(IOUNIT,99019) SEASON(I2), DAYOFWEEK(I1)
                  WRITE(IOUNIT,99014) (I3,QFACT(I3+IFR+IDW,I),I3=1,24)
               END DO
            END DO
         END IF
      END DO

 9002 FORMAT(39X,'* SOURCE EMISSION RATE SCALARS WHICH VARY SEASONALLY',
     &       ' *'//)
 9003 FORMAT(56X,'* FOR ALL SOURCES *'//)
 9004 FORMAT(40X,4(A6,9X)/20X,40('- ')/)
 9005 FORMAT(/10X,' SOURCE ID = ',A8,' ;  SOURCE TYPE = ',A8,' :')
 9006 FORMAT(38X,4(E10.5,5X))
 9007 FORMAT(41X,'* SOURCE EMISSION RATE SCALARS WHICH VARY MONTHLY *',
     &       //)
 9008 FORMAT(7X,'JANUARY  FEBRUARY   MARCH     APRIL      MAY       ',
     &  'JUNE      JULY     AUGUST   SEPTEMBER  OCTOBER  NOVEMBER  ',
     &  'DECEMBER'/)
 9009 FORMAT(/' SOURCE ID = ',A8,' ;  SOURCE TYPE = ',A8,' :')
99009 FORMAT(' SOURCE ID = ',A8,' ;  SOURCE TYPE = ',A8,' :')
 9010 FORMAT(5X,12E10.4)
 9011 FORMAT(28X,'* SOURCE EMISSION RATE SCALARS WHICH VARY FOR EACH',
     &       ' HOUR OF THE DAY *'//)
 9012 FORMAT(5X,6('HOUR    SCALAR',6X))
99012 FORMAT(2X,8('HOUR   SCALAR',3X))
 9013 FORMAT(1X,65('- ')/)
99013 FORMAT(1X,65('- '))
 9014 FORMAT(4(5X,6(I3,3X,E10.5,4X)/))
99014 FORMAT(2(3X,8(I2,2X,E9.4,3X)/),3X,8(I2,2X,E9.4,3X))
 9015 FORMAT(20X,'* SOURCE EMISSION RATE SCALARS WHICH VARY WITH',
     &       ' STABILITY AND WIND SPEED (STAR) *'//)
 9017 FORMAT(19X,A1,5X,6(5X,E10.5))
 9018 FORMAT(22X,'* SOURCE EMISSION RATE SCALARS WHICH VARY',
     &       ' SEASONALLY AND DIURNALLY (SEASHR) *'//)
99018 FORMAT(17X,'* SOURCE EMISSION RATE SCALARS WHICH VARY',
     &       ' SEASONALLY, DIURNALLY AND BY DAY OF WEEK (SHRDOW) *'/)
 9019 FORMAT(59X,'SEASON = ',A6)
99019 FORMAT(49X,'SEASON = ',A6,';  DAY OF WEEK = ',A8)
 9024 FORMAT(6X,'STABILITY CATEGORY ',A1,6(1X,E12.5))
 9025 FORMAT(/26X,6('   WIND SPEED')/26X,6('   CATEGORY',I2))
 9046 FORMAT(//50X,'*** POINT SOURCE DATA ***'///14X,
     & 'NUMBER EMISSION RATE',20X,'BASE     STACK   STACK',4X,
     & 'STACK     STACK    BUILDING EMISSION RATE',/4X,
     & 'SOURCE',5X,'PART. ',A12,5X,'X',8X,'Y',6X,'ELEV.    ',
     & 'HEIGHT  TEMP.   EXIT VEL. DIAMETER',3X,'EXISTS   SCALAR VARY',
     & /4X,'  ID       CATS.              ',
     & 1X,2('(METERS) (METERS) '),'(DEG.K) ',' (M/SEC) ',1X,'(METERS)',
     & 16X,'BY'/61(' -')/)
 9047 FORMAT(3X,A8,2X,I5,3X,E11.5,2F10.1,F8.1,4F9.2,
     &       6X,A3,6X,A6)
 9049 FORMAT(48X,'*** SOURCE PARTICULATE/GAS DATA ***'//)
 9050 FORMAT(//10X,'*** SOURCE ID = ',A8,'; SOURCE TYPE = ',A8,' ***')
 9051 FORMAT(/10X,'MASS FRACTION ='/2(10X,10(F9.5,', ')/))
 9052 FORMAT(/10X,'PARTICLE DIAMETER (MICRONS) ='/2(10X,10(F9.5,', ')
     &       /))
 9053 FORMAT(/10X,'PARTICLE DENSITY (G/CM**3) ='/2(10X,10(F9.5,', '
     &       )/))
 9054 FORMAT(/10X,'SCAV COEF [LIQ] 1/(S-MM/HR)='/2(10X,10(E9.2,', '
     &       )/))
 9055 FORMAT(/10X,'SCAV COEF [ICE] 1/(S-MM/HR)='/2(10X,10(E9.2,', '
     &       )/))
 9058 FORMAT(//43X,'*** SOURCE IDs DEFINING SOURCE GROUPS ***'//
     &       1X,'GROUP ID',49X,'SOURCE IDs'/)
 9068 FORMAT(//2X,A8,1X,12(1X,A8,','))
 9067 FORMAT(/11X,12(1X,A8,','))
 9062 FORMAT(/' SOURCE ID: ',A8,
     &       /,6('  IFV   BH     BW  WAK'),/,
     &       6(6(2X,I3,F6.1,',',F6.1,',',I2,1X)/)/)
 9064 FORMAT(42X,'*** DIRECTION SPECIFIC BUILDING DIMENSIONS ***'/)
 9074 FORMAT(//50X,'*** VOLUME SOURCE DATA ***'//14X,
     & 'NUMBER EMISSION RATE',20X,'BASE    RELEASE    INIT.',4X,
     & 'INIT.   EMISSION RATE',/4X,
     & 'SOURCE',5X,'PART. ',A12,5X,'X',8X,'Y',6X,'ELEV.   ',
     & 'HEIGHT      SY       SZ      SCALAR VARY',
     & /4X,'  ID       CATS.              ',
     & 1X,3('(METERS) (METERS) '),5X,'  BY'/61(' -')/)
 9075 FORMAT(3X,A8,2X,I5,3X,E11.5,2F10.1,F8.1,F9.2,1X,F8.2,1X,
     &       F8.2,3X,A6)
 9076 FORMAT(//50X,'*** AREA SOURCE DATA ***'//14X,
     & 'NUMBER EMISSION RATE',2X,'COORD (SW CORNER)',2X,
     & 'BASE     RELEASE  X-DIM     Y-DIM    ORIENT.',4X,
     & 'INIT.',2X,
     & 'EMISSION RATE',
     & /4X,'SOURCE',5X,'PART. ',A11,7X,'X',8X,'Y',6X,'ELEV.    ',
     & 'HEIGHT  OF AREA   OF AREA   OF AREA     SZ     SCALAR VARY',
     & /4X,'  ID       CATS.   /METER**2)  ',
     & 1X,2('(METERS) (METERS) '),2('(METERS)',2X),' (DEG.)  (METERS)',
     & 6X,'BY'/63(' -')/)
 9077 FORMAT(3X,A8,2X,I5,3X,E11.5,2F10.1,F8.1,F9.2,3(1X,F9.2),1X,F8.2,
     &       5X,A6)
 9078 FORMAT(//48X,'*** AREACIRC SOURCE DATA ***'//14X,
     & 'NUMBER EMISSION RATE',4X,'CENTER OF AREA',3X,
     & 'BASE     RELEASE  RADIUS     NUMBER     INIT.',
     &  4X,'EMISSION RATE',
     & /4X,'SOURCE',5X,'PART. ',A11,7X,'X',8X,'Y',6X,'ELEV.    ',
     & 'HEIGHT   OF AREA   OF VERTS.    SZ       SCALAR VARY',
     & /4X,'  ID       CATS.   /METER**2)  ',
     & 1X,2('(METERS) (METERS) '),21X,'(METERS)        BY'
     & /63(' -')/)
 9079 FORMAT(3X,A8,2X,I5,3X,E11.5,2F10.1,F8.1,F9.2,2X,F9.2,4X,I4,4X,
     &       F8.2,7X,A6)
 9080 FORMAT(//48X,'*** AREAPOLY SOURCE DATA ***'//14X,
     & 'NUMBER EMISSION RATE',3X,'LOCATION OF AREA',2X,
     & 'BASE     RELEASE  NUMBER      INIT.',3X,'EMISSION RATE',
     & /4X,'SOURCE',5X,'PART. ',A11,7X,'X',8X,'Y',6X,'ELEV.    ',
     & 'HEIGHT  OF VERTS.     SZ      SCALAR VARY',
     & /4X,'  ID       CATS.   /METER**2)  ',
     & 1X,2('(METERS) (METERS) '),11X,'(METERS)       BY'
     & /63(' -')/)
 9081 FORMAT(3X,A8,2X,I5,3X,E11.5,2F10.1,F8.1,F9.2,4X,I4,5X,F8.2,6X,A6)
 9082 FORMAT(//50X,'*** OPENPIT SOURCE DATA ***'//14X,
     & 'NUMBER EMISSION RATE',2X,'COORD (SW CORNER)',2X,
     & 'BASE     RELEASE  X-DIM     Y-DIM    ORIENT.',4X,
     & 'VOLUME',3X,'EMISSION RATE',
     & /4X,'SOURCE',5X,'PART. ',A11,7X,'X',8X,'Y',6X,'ELEV.    ',
     & 'HEIGHT  OF PIT    OF PIT    OF PIT     OF PIT    SCALAR VARY',
     & /4X,'  ID       CATS.   /METER**2)  ',
     & 1X,2('(METERS) (METERS) '),2('(METERS)',2X),' (DEG.) ',3X,
     & '(M**3)        BY'
     & /63(' -')/)
 9083 FORMAT(3X,A8,2X,I5,3X,E11.5,2F10.1,F8.1,F9.2,3(1X,F9.2),
     &       3X,E10.5,3X,A6)
 9085 FORMAT(/10X,'SCAV COEF [LIQ] 1/(S-MM/HR)=',2X,E9.2)
 9086 FORMAT(/10X,'SCAV COEF [ICE] 1/(S-MM/HR)=',2X,E9.2)
 9090 FORMAT(/10X,'MOLECULAR DIFF  (M**2/SEC) =',2X,E9.2)
 9091 FORMAT(/10X,'ALPHA STAR                 =',2X,E9.2)
 9092 FORMAT(/10X,'REACTIVITY PARAMETER       =',2X,E9.2)
 9093 FORMAT(/10X,'MESOPHYLL RESIST (SEC/M)   =',2X,E9.2)
 9094 FORMAT(/10X,'HENRY`S LAW COEFFICIENT    =',2X,E9.2)

      RETURN
      END


      SUBROUTINE PRTREC
C***********************************************************************
C                 PRTREC Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Print Out The Receptor Network Values
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To Adjust Format Statement 9082 for Boundary
C                    Receptors - 9/29/92
C
C        INPUTS:  Arrays of Source Parameters
C                 Arrays of Receptor Locations
C                 Arrays of Model Results
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   INPSUM
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, J, K, INDZ, NX, NY, INDC, ISRF
      REAL    :: YCOVAL, XRMS, YRMS, RANGE, RADIAL
      CHARACTER BUF132*132

C     Variable Initializations
      MODNAM = 'PRTREC'

      DO I = 1, INNET
         CALL HEADER
         WRITE(IOUNIT,9034)
         WRITE(IOUNIT,9037) NTID(I), NTTYP(I)
         IF (NTTYP(I) .EQ. 'GRIDCART') THEN
            WRITE(IOUNIT,9038)
         ELSE
            WRITE(IOUNIT,9036) XORIG(I), YORIG(I)
            WRITE(IOUNIT,9039)
         END IF
         WRITE(IOUNIT,9040) (XCOORD(J,I),J=1,NUMXPT(I))
         IF (NTTYP(I) .EQ. 'GRIDCART') THEN
            WRITE(IOUNIT,9041)
         ELSE
            WRITE(IOUNIT,9042)
         END IF
         WRITE(IOUNIT,9040) (YCOORD(J,I),J=1,NUMYPT(I))
         IF (ELEV) THEN
C           Print Terrain Heights for Network
C           Set Number of Columns Per Page, NCPP
            NCPP = 9
C           Set Number of Rows Per Page, NRPP
            NRPP = 40
C           Begin LOOP Through Networks
C           Calculate Number of Pages Per X-Group, NPPX, & Per Y-Group, NPPY
            NPPX = 1 + INT((NUMXPT(I)-1)/NCPP)
            NPPY = 1 + INT((NUMYPT(I)-1)/NRPP)
            DO NX = 1, NPPX
               DO NY = 1, NPPY
                  CALL HEADER
                  WRITE(IOUNIT,9037) NTID(I), NTTYP(I)
                  WRITE(IOUNIT,9011)
                  IF (NX .EQ. NPPX) THEN
                     IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                        WRITE(IOUNIT,9016)
                        WRITE(IOUNIT,9017) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NUMXPT(I))
                     ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                        WRITE(IOUNIT,9018)
                        WRITE(IOUNIT,9019) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NUMXPT(I))
                     END IF
                  ELSE
                     IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                        WRITE(IOUNIT,9016)
                        WRITE(IOUNIT,9017) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NCPP*NX)
                     ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                        WRITE(IOUNIT,9018)
                        WRITE(IOUNIT,9019) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NCPP*NX)
                     END IF
                  END IF
                  WRITE(IOUNIT,9010)
                  IF (NY .EQ. NPPY) THEN
                     DO K = 1+NRPP*(NY-1), NUMYPT(I)
                        IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        END IF
                        IF (NX .EQ. NPPX) THEN
                           WRITE(IOUNIT,9013) YCOVAL,
     &                   (AZELEV(INDZ+J-1),J=1+NCPP*(NX-1),NUMXPT(I))
                        ELSE
                           WRITE(IOUNIT,9013) YCOVAL,
     &                   (AZELEV(INDZ+J-1),J=1+NCPP*(NX-1),NCPP*NX)
                        END IF
                     END DO
                  ELSE
                     DO K = 1+NRPP*(NY-1), NRPP*NY
                        IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        END IF
                        IF (NX .EQ. NPPX) THEN
                           WRITE(IOUNIT,9013) YCOVAL,
     &                   (AZELEV(INDZ+J-1),J=1+NCPP*(NX-1),NUMXPT(I))
                        ELSE
                           WRITE(IOUNIT,9013) YCOVAL,
     &                   (AZELEV(INDZ+J-1),J=1+NCPP*(NX-1),NCPP*NX)
                        END IF
                     END DO
                  END IF
               END DO
            END DO
         END IF
         IF (FLGPOL) THEN
C           Print The Receptor Heights Above Ground for This Network
C           Set Number of Columns Per Page, NCPP
            NCPP = 9
C           Set Number of Rows Per Page, NRPP
            NRPP = 40
C           Begin LOOP Through Networks
C           Calculate Number of Pages Per X-Group, NPPX, & Per Y-Group, NPPY
            NPPX = 1 + INT((NUMXPT(I)-1)/NCPP)
            NPPY = 1 + INT((NUMYPT(I)-1)/NRPP)
            DO NX = 1, NPPX
               DO NY = 1, NPPY
                  CALL HEADER
                  WRITE(IOUNIT,9037) NTID(I), NTTYP(I)
                  WRITE(IOUNIT,9035)
                  IF (NX .EQ. NPPX) THEN
                     IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                        WRITE(IOUNIT,9016)
                        WRITE(IOUNIT,9017) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NUMXPT(I))
                     ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                        WRITE(IOUNIT,9018)
                        WRITE(IOUNIT,9019) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NUMXPT(I))
                     END IF
                  ELSE
                     IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                        WRITE(IOUNIT,9016)
                        WRITE(IOUNIT,9017) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NCPP*NX)
                     ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                        WRITE(IOUNIT,9018)
                        WRITE(IOUNIT,9019) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NCPP*NX)
                     END IF
                  END IF
                  WRITE(IOUNIT,9010)
                  IF (NY .EQ. NPPY) THEN
                     DO K = 1+NRPP*(NY-1), NUMYPT(I)
                        IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        END IF
                        IF (NX .EQ. NPPX) THEN
                           WRITE(IOUNIT,9013) YCOVAL,
     &                   (AZFLAG(INDZ+J-1),J=1+NCPP*(NX-1),NUMXPT(I))
                        ELSE
                           WRITE(IOUNIT,9013) YCOVAL,
     &                   (AZFLAG(INDZ+J-1),J=1+NCPP*(NX-1),NCPP*NX)
                        END IF
                     END DO
                  ELSE
                     DO K = 1+NRPP*(NY-1), NRPP*NY
                        IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        END IF
                        IF (NX .EQ. NPPX) THEN
                           WRITE(IOUNIT,9013) YCOVAL,
     &                   (AZFLAG(INDZ+J-1),J=1+NCPP*(NX-1),NUMXPT(I))
                        ELSE
                           WRITE(IOUNIT,9013) YCOVAL,
     &                   (AZFLAG(INDZ+J-1),J=1+NCPP*(NX-1),NCPP*NX)
                        END IF
                     END DO
                  END IF
               END DO
            END DO
         END IF
      END DO

      IF (IRSTAT(4) .NE. 0) THEN
C        Print Out The Coordinates, Height & Flags For Discrete Cart Receptors
         INDC = 0
         DO I = 1, NUMREC
            IF (RECTYP(I) .EQ. 'DC') THEN
               INDC = INDC + 1
               IF (MOD(INDC-1,90) .EQ. 0) THEN
                  CALL HEADER
                  WRITE(IOUNIT,9043)
               END IF
               IF (MOD(INDC,2) .NE. 0) THEN
                  WRITE(BUF132(1:55),9045) AXR(I),AYR(I),AZELEV(I),
     &                                     AZFLAG(I)
               ELSE
                  WRITE(BUF132(56:110),9045) AXR(I),AYR(I),AZELEV(I),
     &                                       AZFLAG(I)
                  WRITE(IOUNIT,9090) BUF132
                  WRITE(BUF132,9095)
               END IF
            END IF
         END DO
         IF (MOD(INDC,2) .NE. 0) THEN
            WRITE(IOUNIT,9090) BUF132
            WRITE(BUF132,9095)
         END IF
      END IF

      IF (IRSTAT(5) .NE. 0) THEN
C        Print Out The Coordinates, Height & Flags For Discrete Polar Receptors
         INDC = 0
         DO I = 1, NUMREC
            IF (RECTYP(I) .EQ. 'DP') THEN
               INDC = INDC + 1
               XRMS = AXR(I) - AXS(IREF(I))
               YRMS = AYR(I) - AYS(IREF(I))
               RANGE  = SQRT(XRMS*XRMS + YRMS*YRMS)
               RADIAL = ATAN2(XRMS, YRMS) * RTODEG
               IF(RADIAL .LE. 0.0) RADIAL = RADIAL + 360.
               IF (MOD(INDC-1,90) .EQ. 0) THEN
                  CALL HEADER
                  WRITE(IOUNIT,9044)
               END IF
               IF (MOD(INDC,2) .NE. 0) THEN
                  WRITE(BUF132(1:65),9047) SRCID(IREF(I)),RANGE,RADIAL,
     &                                     AZELEV(I),AZFLAG(I)
               ELSE
                  WRITE(BUF132(66:130),9047) SRCID(IREF(I)),RANGE,
     &                                       RADIAL,AZELEV(I),AZFLAG(I)
                  WRITE(IOUNIT,9090) BUF132
                  WRITE(BUF132,9095)
               END IF
            END IF
         END DO
         IF (MOD(INDC,2) .NE. 0) THEN
            WRITE(IOUNIT,9090) BUF132
            WRITE(BUF132,9095)
         END IF
      END IF

      IF (IRSTAT(6) .NE. 0) THEN
C        Write Out The Boundary Receptors For The Sources
         INDC = 0
         I = 1
         DO WHILE (I .LE. NUMREC)
            IF (RECTYP(I) .EQ. 'BD') THEN
               INDC = INDC + 1
               ISRF = IREF(I)
               IF (MOD(INDC-1,3) .EQ. 0) THEN
                  CALL HEADER
                  WRITE(IOUNIT,9084)
               END IF
               WRITE(IOUNIT,9082) SRCID(ISRF),SRCTYP(ISRF),
     &             AXS(ISRF),AYS(ISRF),AZS(ISRF),
     &             (J,AXR(I+J-1),AYR(I+J-1),AZELEV(I+J-1),
     &              AZFLAG(I+J-1),J=1,36)
               I = I + 36
            ELSE
               I = I + 1
            END IF
         END DO
      END IF

 9011 FORMAT(/48X,'* ELEVATION HEIGHTS IN METERS *'/)
 9035 FORMAT(/44X,'* RECEPTOR FLAGPOLE HEIGHTS IN METERS *'/)
 9034 FORMAT(/40X,'*** GRIDDED RECEPTOR NETWORK SUMMARY ***')
 9037 FORMAT(/34X,'*** NETWORK ID: ',A8,' ;  NETWORK TYPE: ',
     &       A8,' ***')
 9038 FORMAT(/42X,'*** X-COORDINATES OF GRID ***'/
     &       52X,'(METERS)'/)
 9039 FORMAT(/42X,'*** DISTANCE RANGES OF NETWORK ***'/
     &       52X,'(METERS)'/)
 9036 FORMAT(/42X,'*** ORIGIN FOR POLAR NETWORK ***'/,
     &      32X,'X-ORIG =',F10.2,' ;   Y-ORIG = ',F10.2,'  (METERS)')
 9040 FORMAT(100(5X,10(F10.1,',')/))
 9041 FORMAT(/42X,'*** Y-COORDINATES OF GRID *** ',
     &       /52X,'(METERS)'/)
 9042 FORMAT(/42X,'*** DIRECTION RADIALS OF NETWORK *** ',
     &       /52X,'(DEGREES)'/)
 9010 FORMAT(66(' -')/)
 9013 FORMAT(2X,F10.2,1X,'|',1X,9(1X,F12.2,:))
 9016 FORMAT(3X,' Y-COORD  |',48X,'X-COORD (METERS)')
 9017 FORMAT(3X,' (METERS) |',1X,9(1X,F12.2,:))
 9018 FORMAT(3X,'DIRECTION |',48X,'DISTANCE (METERS)')
 9019 FORMAT(3X,'(DEGREES) |',1X,9(1X,F12.2,:))
 9043 FORMAT(/45X,'*** DISCRETE CARTESIAN RECEPTORS ***',
     &       /45X,'  (X-COORD, Y-COORD, ZELEV, ZFLAG)',
     &       /45X,'              (METERS)'/)
 9044 FORMAT(/45X,' *** DISCRETE POLAR RECEPTORS ***',
     &       /45X,' ORIGIN: (DIST, DIR, ZELEV, ZFLAG)',
     &       /45X,' SRCID: (METERS,DEG,METERS,METERS)'/)
 9045 FORMAT(4X,' (',3(F9.1,', '),F9.1,'); ')
 9047 FORMAT(4X,A8,': (',3(F9.1,', '),F9.1,'); ')
 9082 FORMAT(' BOUNDARY RECEPTORS FOR SOURCE ID: ',A8,/,5X,
     &       ' OF SOURCE TYPE: ',A8,'; WITH ORIGIN AT (',2(F10.2,', '),
     &     F10.2,')'/3(' SEC.    XCOORD      YCOORD   ZELEV  ZFLAG',3X),
     &       /,12(3(I4,1X,F10.2,', ',F10.2,',',F7.2,',',F6.1,3X),/),/)
 9084 FORMAT(/50X,'*** BOUNDARY RECEPTOR LOCATIONS ***',
     &    /47X,'(DISCRETE RECEPTORS AT 10 DEGREE SECTORS)'//)
 9090 FORMAT(A132)
 9095 FORMAT(132(' '))

      RETURN
      END

      SUBROUTINE CHKREC
C***********************************************************************
C                 CHKREC Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Print Out The Input Met Data Summary and Source Groups
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To account for new area source algorithm, which
C                    allows for receptors located within the area - 7/7/93
C
C        MODIFIED:   To account for OpenPit Source - PES - 7/22/94
C
C        INPUTS:  Source and Receptor Inputs
C
C        OUTPUTS: Listing of Receptors Too Close To Sources
C
C        CALLED FROM:   INPSUM
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: INC, ISEC, INOUT
      REAL    :: DIST, ANG, XMIN, XVM(5), YVM(5)

C     Variable Initializations
      MODNAM = 'CHKREC'
      INC = 0

C     Begin Source LOOP
      DO ISRC = 1, NUMSRC

C        Set Effective Source Radius Based on Source Type
         IF (SRCTYP(ISRC) .EQ. 'POINT') THEN
            XRAD = 0.0
         ELSE IF (SRCTYP(ISRC) .EQ. 'VOLUME') THEN
            XRAD = 2.15 * ASYINI(ISRC)
         ELSE IF (SRCTYP(ISRC) .EQ. 'AREA' .OR.
     &            SRCTYP(ISRC) .EQ. 'AREAPOLY' .OR.
     &            SRCTYP(ISRC) .EQ. 'AREACIRC') THEN
C           Cycle to Next Source for AREA Sources - No Restrictions on
C           Receptor Placement for New Algorithm
            CYCLE
         ELSE IF (SRCTYP(ISRC) .EQ. 'OPENPIT') THEN
            XRAD   = -1.0
            XVM(1) = AXVERT(1,ISRC)
            XVM(2) = AXVERT(2,ISRC)
            XVM(3) = AXVERT(3,ISRC)
            XVM(4) = AXVERT(4,ISRC)
            XVM(5) = AXVERT(5,ISRC)
            YVM(1) = AYVERT(1,ISRC)
            YVM(2) = AYVERT(2,ISRC)
            YVM(3) = AYVERT(3,ISRC)
            YVM(4) = AYVERT(4,ISRC)
            YVM(5) = AYVERT(5,ISRC)
         END IF

C        Begin Receptor LOOP
         DO IREC = 1, NUMREC

C           Calculate DIST From Edge of Source to Receptor
            X = AXR(IREC) - AXS(ISRC)
            Y = AYR(IREC) - AYS(ISRC)
            DIST = SQRT (X*X + Y*Y) - XRAD

            IF (DIST .LT. 0.99) THEN
C              Receptor Is Too Close To Source
               INC = INC + 1
               IF (MOD((INC-1), 40) .EQ. 0) THEN
                  CALL HEADER
                  WRITE(IOUNIT,9002)
               END IF
               WRITE(IOUNIT,9003) SRCID(ISRC), AXR(IREC),
     &                            AYR(IREC), DIST
            ELSE IF (SRCTYP(ISRC) .EQ. 'POINT') THEN
C              Check For Receptors Less Than 3*ZLB For POINT Sources
               ANG = ATAN2(X,Y) * RTODEG
               IF (ANG .LT. 0.0) ANG = ANG + 360.0
               ISEC = INT(ANG*0.10 + 0.4999)
               IF (ISEC .EQ. 0) ISEC = 36
               IF (ISEC .LE. NSEC) THEN
                  DSBH = ADSBH(ISEC,ISRC)
                  DSBW = ADSBW(ISEC,ISRC)
                  XMIN = 3.*MIN(DSBH,DSBW)
                  IF (DIST .LT. XMIN) THEN
C                    Receptor Is Too Close To Source
                     INC = INC + 1
                     IF (MOD((INC-1), 40) .EQ. 0) THEN
                        CALL HEADER
                        WRITE(IOUNIT,9002)
                     END IF
                     WRITE(IOUNIT,9003) SRCID(ISRC), AXR(IREC),
     &                                  AYR(IREC), DIST
                  END IF
               END IF
            ELSE IF (SRCTYP(ISRC) .EQ. 'OPENPIT') THEN
C              Check for receptors within boundary of an open pit source
               XR = AXR(IREC)
               YR = AYR(IREC)
               CALL PNPOLY(XR,YR,XVM,YVM,5,INOUT)
               IF (INOUT .GT. 0) THEN
C                 Receptor is within boundary
                  INC = INC + 1
                  IF (MOD((INC-1), 40) .EQ. 0) THEN
                     CALL HEADER
                     WRITE(IOUNIT,9002)
                  END IF
                  WRITE(IOUNIT,9004) SRCID(ISRC), AXR(IREC),
     &                               AYR(IREC)
               END IF
            END IF

         END DO
C        End Receptor LOOP

      END DO
C     End Source LOOP

 9002 FORMAT(22X,'* SOURCE-RECEPTOR COMBINATIONS FOR WHICH ',
     & 'CALCULATIONS MAY NOT BE PERFORMED *'/27X,'LESS THAN 1.0 METER',
     & ' OR 3*ZLB IN DISTANCE, OR WITHIN OPEN PIT SOURCE',//
     & /31X,'SOURCE',9X,'- - RECEPTOR LOCATION - -',9X,'DISTANCE',
     & /31X,'  ID  ',9X,'XR (METERS)   YR (METERS)',9X,'(METERS)',
     & /30X,30('- ')/)
 9003 FORMAT(31X,A8,5X,F13.1,1X,F13.1,7X,F10.2)
 9004 FORMAT(31X,A8,5X,F13.1,1X,F13.1,7X,'   OPENPIT')

      RETURN
      END

      SUBROUTINE PRTMET
C***********************************************************************
C                 PRTMET Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Print Out The Input Met Data Summary and Source Groups
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To output 4-digit start year and end year for
C                    Y2K compliance.
C                    R.W. Brode, PES, Inc., 5/12/99
C
C        INPUTS:  Model Options and Keyword Summarys
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   INPSUM
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, J, K
      CHARACTER ATHRUF(6)*1

C     Variable Initializations
      DATA ATHRUF / 'A','B','C','D','E','F' /
      MODNAM = 'PRTMET'

C     Start New Page and Print The Titles
      CALL HEADER

C     Print The Meteorology Data Date Array.
      WRITE(IOUNIT,9037) (IPROC(I),I = 1, 366)

      IF (ISDATE .NE. 0 .OR. IEDATE .NE. 2147483647) THEN
C        Write Out User-specified Start and End Dates
         WRITE(IOUNIT,9038) ISYR, ISMN, ISDY, ISHR,
     &                      IEYR, IEMN, IEDY, IEHR
      END IF

      WRITE(IOUNIT,9039)

C     Print Upper Bound Of First 5 Wind Speed Categories.
      WRITE(IOUNIT,9001) (UCAT(I),I=1,5)

C     Print Wind Profile Exponents
      IF (DFAULT .OR. .NOT.USERP) THEN
         IF (URBAN) THEN
            DO I = 1, 6
               DO J = 1, 6
                  PUSER(I,J) = PURB(I)
               END DO
            END DO
         ELSE IF (RURAL) THEN
            DO I = 1, 6
               DO J = 1, 6
                  PUSER(I,J) = PRUR(I)
               END DO
            END DO
         END IF
      END IF
      WRITE(IOUNIT,9059)
      WRITE(IOUNIT,9016) (K,K=1,6)
      DO I = 1, 6
         WRITE(IOUNIT,9017) ATHRUF(I), (PUSER(I,J),J=1,6)
      END DO

C     Print Vertical Potential Temperature Gradients
      IF (DFAULT .OR. .NOT.USERDT) THEN
         IF (URBAN) THEN
            DO I = 1, 6
               DO J = 1, 6
                  DTUSER(I,J) = DTURB(I)
               END DO
            END DO
         ELSE IF (RURAL) THEN
            DO I = 1, 6
               DO J = 1, 6
                  DTUSER(I,J) = DTRUR(I)
               END DO
            END DO
         END IF
      END IF
      WRITE(IOUNIT,9060)
      WRITE(IOUNIT,9016) (K, K=1,6)
      DO I = 1, 6
         WRITE(IOUNIT,9017) ATHRUF(I), (DTUSER(I,J),J=1,6)
      END DO

 9001 FORMAT(//34X,'*** UPPER BOUND OF FIRST THROUGH FIFTH WIND SPEED',
     &       ' CATEGORIES ***'/60X,'(METERS/SEC)'//46X,5(F7.2,','))
 9016 FORMAT(16X,'STABILITY',29X,'WIND SPEED CATEGORY'/16X,'CATEGORY',
     &       9X,6(I1,14X))
 9017 FORMAT(19X,A1,5X,6(5X,E10.5))
 9037 FORMAT(/44X,'*** METEOROLOGICAL DAYS SELECTED FOR PROCESSING ***'
     &       /63X,'(1=YES; 0=NO)'//8(11X,5(10I2,2X)/))
 9038 FORMAT(/23X,'METEOROLOGICAL DATA PROCESSED BETWEEN START DATE: ',
     &       I4,1X,3I3,/59X,'AND END DATE: ',I4,1X,3I3)
 9039 FORMAT(/16X,'NOTE:  METEOROLOGICAL DATA ACTUALLY PROCESSED WILL',
     &       ' ALSO DEPEND ON WHAT IS INCLUDED IN THE DATA FILE.'/)
 9059 FORMAT(//51X,'*** WIND PROFILE EXPONENTS ***'//)
 9060 FORMAT(//42X,'*** VERTICAL POTENTIAL TEMPERATURE GRADIENTS ***'/
     &       53X,'(DEGREES KELVIN PER METER)'//)

      RETURN
      END

      SUBROUTINE RSINIT
C***********************************************************************
C                 RSINIT Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: To Initialize Results Variables for Restart
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   Added arrays associated with post-1997 PM10
C                    processing.
C                    R.W. Brode, PES, Inc.,  5/12/99
C
C        MODIFIED:   Changed parameter for specifying the number of
C                    high annual/period averages from NVAL to NHIANN.
C                    R.W. Brode, PES, Inc.,  4/3/98
C
C        INPUTS:  None
C
C        OUTPUTS: Initialized Variables
C
C        CALLED FROM:   MAIN
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, J, K, L, M

C     Variable Initializations
      MODNAM = 'RSINIT'

      READ(IRSUNT,ERR=99,END=999) ISDATE
      READ(IRSUNT,ERR=99,END=999) NHIVAL, NMXVAL, NUMREC, NUMGRP,
     &                            NUMAVE, NUMTYP

      IF (NHIVAL .GT. 0) THEN
         READ(IRSUNT,ERR=99,END=999) (((((HIVALU(I,J,K,L,M),I=1,NUMREC),
     &                   J=1,NHIVAL),K=1,NUMGRP),L=1,NUMAVE),M=1,NUMTYP)
         READ(IRSUNT,ERR=99,END=999) (((((NHIDAT(I,J,K,L,M),I=1,NUMREC),
     &                   J=1,NHIVAL),K=1,NUMGRP),L=1,NUMAVE),M=1,NUMTYP)
         READ(IRSUNT,ERR=99,END=999) (((((HCLMSG(I,J,K,L,M),I=1,NUMREC),
     &                   J=1,NHIVAL),K=1,NUMGRP),L=1,NUMAVE),M=1,NUMTYP)

         IF (PM10AVE) THEN
            READ(IRSUNT,ERR=99,END=999) NUMYRS
            READ(IRSUNT,ERR=99,END=999) ((SUMH4H(I,J),I=1,NUMREC),
     &                                                J=1,NUMGRP)
         END IF

      END IF

      IF (NMXVAL .GT. 0) THEN
         READ(IRSUNT,ERR=99,END=999) ((((RMXVAL(I,J,K,L),I=1,NMXVAL),
     &                               J=1,NUMGRP),K=1,NUMAVE),L=1,NUMTYP)
         READ(IRSUNT,ERR=99,END=999) ((((MXDATE(I,J,K,L),I=1,NMXVAL),
     &                               J=1,NUMGRP),K=1,NUMAVE),L=1,NUMTYP)
         READ(IRSUNT,ERR=99,END=999) ((((MXLOCA(I,J,K,L),I=1,NMXVAL),
     &                               J=1,NUMGRP),K=1,NUMAVE),L=1,NUMTYP)
         READ(IRSUNT,ERR=99,END=999) ((((MCLMSG(I,J,K,L),I=1,NMXVAL),
     &                               J=1,NUMGRP),K=1,NUMAVE),L=1,NUMTYP)
      END IF

      IF (SEASONHR) THEN
C        Initialize the SEASON by HOUR-OF-DAY Arrays
         READ(IRSUNT,ERR=99,END=999) (((((SHVALS(I,J,K,L,M),I=1,NUMREC),
     &                           J=1,NUMGRP),K=1,4),L=1,24),M=1,NUMTYP)
         READ(IRSUNT,ERR=99,END=999) ((NSEAHR(I,J),I=1,4),J=1,24)
         READ(IRSUNT,ERR=99,END=999) ((NSEACM(I,J),I=1,4),J=1,24)
      END IF

      IF (PERIOD) THEN
         READ(IRSUNT,ERR=99,END=999) IANHRS, IANCLM, IANMSG
         READ(IRSUNT,ERR=99,END=999) (((ANNVAL(I,J,K),I=1,NUMREC),
     &                                    J=1,NUMGRP),K=1,NUMTYP)
      ELSE IF (ANNUAL) THEN
         READ(IRSUNT,ERR=99,END=999) IANHRS, IANCLM, IANMSG, NUMYRS
         READ(IRSUNT,ERR=99,END=999) (((ANNVAL(I,J,K),I=1,NUMREC),
     &                                    J=1,NUMGRP),K=1,NUMTYP)
         READ(IRSUNT,ERR=99,END=999) (((SUMANN(I,J,K),I=1,NUMREC),
     &                                    J=1,NUMGRP),K=1,NUMTYP)
      END IF

      IF (MULTYR .AND. PERIOD) THEN
C        Reinitialize the ANNVAL Array and Annual Counters
         DO K = 1, NUMTYP
            DO J = 1, NUMGRP
               DO I = 1, NUMREC
                  ANNVAL(I,J,K) = 0.0
               END DO
            END DO
         END DO
         IANHRS = 0
         IANCLM = 0
         IANMSG = 0
C        Read the Maximum Annual Values
         READ(IRSUNT,ERR=99,END=999) (((AMXVAL(I,J,K),I=1,NHIANN),
     &                                    J=1,NUMGRP),K=1,NUMTYP)
         READ(IRSUNT,ERR=99,END=999) (((IMXLOC(I,J,K),I=1,NHIANN),
     &                                    J=1,NUMGRP),K=1,NUMTYP)
      END IF

      GO TO 1000

C     WRITE Error Message:  Error Reading INITFILE
 99   DUMMY = 'INITFILE'
      CALL ERRHDL(PATH,MODNAM,'E','510',DUMMY)
      RUNERR = .TRUE.
      GO TO 1000

C     WRITE Error Message:  End of File Reached for INITFILE
 999  DUMMY = 'INITFILE'
      CALL ERRHDL(PATH,MODNAM,'E','580',DUMMY)
      RUNERR = .TRUE.

 1000 RETURN
      END

      SUBROUTINE RESINI
C***********************************************************************
C                 RESINI Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: To Initialize Results Variables With Zeroes
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   Added results arrays for post-1997 PM10 processing
C                    option.  Also replaced labeled DO loop terminators
C                    with unlabeled END DO statements.
C                    R.W. Brode, PES, Inc.,  11/19/98
C
C        MODIFIED:   Changed parameter for specifying the number of
C                    high annual/period averages from NVAL to NHIANN.
C                    R.W. Brode, PES, Inc.,  4/3/98
C
C        INPUTS:  None
C
C        OUTPUTS: Initialized Variables
C
C        CALLED FROM:   MAIN
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, J, K, L, M

C     Variable Initializations
      MODNAM = 'RESINI'

C     Initialize the Results Arrays
      DO M = 1, NUMTYP
         HRVAL(M) = 0.0
         DO L = 1, NUMAVE
            NUMHRS(L) = 0
            NUMCLM(L) = 0
            NUMMSG(L) = 0
            DO K = 1, NUMGRP
               DO J = 1, NUMREC
                  AVEVAL(J,K,L,M) = 0.0
                  DO I = 1, NHIVAL
                     HIVALU(J,I,K,L,M) = 0.0
                     NHIDAT(J,I,K,L,M) = 0
                     HCLMSG(J,I,K,L,M) = ' '
                     HMAX(I,K,L,M)   = 0.0
                     HMDATE(I,K,L,M) = 0
                     HMLOC(I,K,L,M)  = 0
                     HMCLM(I,K,L,M)  = ' '
                  END DO
               END DO
               DO J = 1, NMXVAL
                  RMXVAL(J,K,L,M) = 0.0
                  MXDATE(J,K,L,M) = 0
                  MXLOCA(J,K,L,M) = 0
                  MCLMSG(J,K,L,M) = ' '
               END DO
            END DO
         END DO
      END DO
      IANHRS = 0
      IANCLM = 0
      IANMSG = 0

C     The following were added as part of implementing the SCIM option
      NSKIPTOT = 0
      NSKIPWET = 0
      NSKIPDRY = 0
      NSWETCLM = 0
      NSDRYCLM = 0
      IANWET   = 0
      IWETCLM  = 0
      IWETMSG  = 0
      NWETHR   = 0

      DO K = 1, NUMTYP
         DO J = 1, NUMGRP
            DO I = 1, NUMREC
               ANNVAL(I,J,K) = 0.0
               SUMANN(I,J,K) = 0.0
            END DO
            DO I = 1, NHIANN
               AMXVAL(I,J,K) = 0.0
               IMXLOC(I,J,K) = 0
            END DO
         END DO
      END DO

C     Initialize results array for post-1997 PM10 processing
      DO J = 1, NUMGRP
         DO I = 1, NUMREC
            SUMH4H(I,J) = 0.0
         END DO
         DO I = 1, NMXPM
            MXPMVAL(I,J) = 0.0
            MXPMLOC(I,J) = 0
         END DO
      END DO

C     Initialize results arrays for SEASONHR option
      DO M = 1, NUMTYP
         DO L = 1, 24
            DO K = 1, 4
               DO J = 1, NUMGRP
                  DO I = 1, NUMREC

                     SHVALS(I,J,K,L,M) = 0.0

                  END DO
               END DO
            END DO
         END DO
      END DO

      DO J = 1, 24
         DO I = 1, 4

            NSEAHR(I,J) = 0
            NSEACM(I,J) = 0

         END DO
      END DO

      RETURN
      END
