. ./Config.sh
. ./ansictrl.sh
. ./restore_common.sh


## debug mode (if for real remove 'echo' command)
DEBUG=

# Version
VERSION=`cat /etc/recovery/VERSION`


if [ "${RESTORE_DEV}" = "CDROM" ]; then
   Check_Multi_volume   # are we dealing with a multi volume CD? True=0
fi

DeviceCdrom             # define CDROM (eg. /dev/hdc)

cd /etc/recovery
for mdsk  in `ls mkfs.* md/mkfs.* lvm/mkfs.* 2>/dev/null`
do
  _dsk=`echo ${mdsk} | cut -d"." -f 2`
  dsk=`echo ${_dsk} | tr "_" "/" | sed -e 's/%137/_/g'`
  print "\nDisk /dev/${dsk} contains out of the following partition(s):\n"
  grep ${dsk} /etc/recovery/To_Restore | awk '{printf "%s\t%s\t\t%s\n", $1, $2, $3}'

  # List all partitions with one disk, e.g. hda[1-19]
    cat /etc/recovery/To_Restore | grep ${dsk} | \
    { while read Line
    do
      sync; sync; sync
      umount /dev/${Dev}
    done
    } # end of while loop
done # end for dsk loop
